#!/usr/bin/env python3
import argparse, os, sys, runpy, builtins

def main():
    ap = argparse.ArgumentParser()
    ap.add_argument("--manifest", required=True)
    ap.add_argument("--outdir", required=True)
    args = ap.parse_args()

    engine_path = os.path.join(os.path.dirname(__file__), "engine_i24_no_signalling.py")

    orig_any = builtins.any
    def patched_any(x):
        return x if isinstance(x, bool) else orig_any(x)
    builtins.any = patched_any
    try:
        old_argv = sys.argv[:]
        sys.argv = ["engine_i24_no_signalling.py", "--manifest", args.manifest, "--outdir", args.outdir]
        runpy.run_path(engine_path, run_name="__main__")
    finally:
        builtins.any = orig_any
        sys.argv = old_argv

if __name__ == "__main__":
    main()
